Procedure Mineral_Assay;
{part of detailed print out below}
Begin;
  {$I-}
  For V := 0 to 5 do Minerals[v] := 0;
  Minerals [0] := 30 + Random(10);
  Minerals [1] := 10 + Random(10);
  for V := 2 to 5 do Minerals [V]:= Random(5);
  if Copy (WG_System,4,1) >='*' then if Copy (WG_System,4,1) <= ')' then
  for V := 3 to 5 do Minerals[V] := Minerals[V] + 2;
  X:= 0;
  For V := 0 to 5 do X:= X + Minerals[v];
  For V := X+1 to 100 do begin;
    N := Random(100);
    If N<61 then Minerals[0] := Minerals[0]+1
    else if N<80 then Minerals[1] := Minerals[1]+1
    else if N<93 then Minerals[2] := Minerals[2]+1
    else if N<96 then Minerals[3] := Minerals[3]+1
    else if N<99 then Minerals[4] := Minerals[4]+1
    else Minerals[5] := Minerals[5] +1;
  end;
  Writeln(lst);
  If Planet_Code <> '0' then if Planet_Code <> 'S' then Writeln(lst,'CRUST COMPOSITION') else Writeln(Lst,'COMPOSITION');
  For V:= 0 to 5 do Writeln(lst,Mineral_Name[v]:15,Minerals[v]:3,' %');
  If Planet_Code < 'Q' then writeln(Lst,'AVERAGE - LOCAL VALUES MAY VARY')
  else if Planet_Code <'S' then Writeln(lst,'ACCESSIBLE MINERALS ARE MICROSCOPIC PROPORTION OF MASS')
  else writeln(Lst,'AVERAGE - LOCAL VALUES MAY VARY');
  {$I+}
  OK := (IOresult = 0);
  if not OK then exit;
End;

Procedure Detailed_Print_Out;
{Take details generated by other parts of world generation routine and
send them to the printer, with extra information, for statistics run}
Begin;
{$I-}
  RandSeed := Old_Seed[0] + Old_Seed[1];
  Write(Lst,'System ',Y_Coordinate, X_Coordinate, Z_coordinate,' ');
  If Planet_Number = 0 then Write(Lst,'Primary - ')
  else Write(Lst,'[',Body_Count,'] - ');

  Case Char(Ord(Planet_Code[1])) of
         'Q': Writeln (Lst,'Ring world with exotic atmosphere');
         'R': Writeln (Lst,'Ring world with oxygen atmosphere');
         'S': Writeln (Lst,'Dust cloud');
         '*': Writeln (Lst,'Binary star');
         '(': Writeln (Lst,'Black hole');
         ')': Writeln (Lst,'Proto-star');
         '0': writeln (Lst,'Asteroid Belt');
         '1': Writeln (Lst,'Oxygen world');
         '2': Writeln (Lst,'World with exotic atmosphere');
    '3'..'5': Begin;
                Write (Lst,'Small world, ');
                If Pressure = 0 then Writeln(lst,'No atmosphere')
                else writeln(lst,'Trace atmosphere');
              End;
    '6'..'9': If Planet_Code <'8' then writeln(Lst,'Gas giant')
                else writeln(Lst,'Ringed gas giant');
    'A'..'M': Writeln(lst, Star_Type,' type star');
   end;

   If Planet_Code <> '*' then begin;
     For V:= 0 to 8 do
     if Atmosphere [V] > 0 then writeln(Lst,Gasses[V]:15, Atmosphere[V]:3,' %');
     If Pressure >1 then Str(Pressure:5:2,Air_Force) else Str(Pressure:5:4,Air_Force);
     Case Char(Ord(Planet_Code[1])) of
           '1'..'9' : Writeln(Lst,'Pressure: ',Air_Force,' <Earth = 1>');
           'Q'..'R' : Writeln(Lst,'Pressure: ',Air_Force,' <Earth = 1>');
         end;
     Write(Lst,'Gravity = ',Pull);
     If Planet_Code = '0' then write(Lst,' <Average>');
     Writeln(lst);
     If Planet_Code <> '(' then Writeln(Lst,'Av. Temperature ',Heat,' degrees K')
       else Writeln(lst,'Temperature unknown');
     If Planet_Code >='A' then if Planet_code <='M' then begin;
        Writeln(Lst,'Mass = ',Exact_Mass:6:3,' [Sol = 1.0]');
        Writeln(Lst,'Luminosity = ',Luminosity:9:4,' [Sol = 1.0]');
        Writeln(Lst,'Diameter = ',Exact_Radius * 1392000.0:10:0, ' Km');
     end;

     If Planet_Code <>'0' then if Planet_Code <'Q' then Writeln(Lst,'Axial tilt ',tilt,' degrees [to plane of ecliptic]');
     If planet_Number > 0 then begin;
       If Planet_Code = '0' then write(Lst,'Average ');
       If Planet_Code <> 'Q' then if Planet_Code <> 'R' then Writeln(Lst,'Orbital eccentricity ',Mean_Eccentricity:5:4);
       If Planet_Code = '0' then write(Lst,'Average ');
       Writeln(lst,'Mean orbital radius ',Orbital_Distance:6:2,' AU');
       Case Native_Life of
         1..3: Writeln(Lst,'* Primitive native life-forms');
         4..6: Writeln(lst,'* Complex native life-forms');
        7..20: Writeln(lst,'* Intelligent native life-forms');
       end;
       If native_Life >6 then Case Native_Technology of
            0: Writeln(lst,'* No native technology');
         1..5: Writeln(lst,'* Native technology pre-industrial');
         6..9: Writeln(lst,'* Native technology industrial, pre space-flight');
       10..11: Writeln(Lst,'* Native technology includes space flight');
       12..20: Writeln(Lst,'* Native technology includes interstellar travel');
       end;

       If Colonies[1] > 0 then writeln(Lst,'* Human colonies: ',Colonies[1]);
       If Colonies[2] > 0 then writeln(Lst,'* Alien colonies: ',Colonies[2]);

       if Planet_Code >= 'Q' then if Planet_Code <='R' then Begin;
          Writeln(lst,'Orbital Velocity = ',Orbital_Velocity:20:0,' Metres/second');
          Writeln(lst,'Ringworld circumference = ',Circumference:20:0,' metres');
          Writeln(Lst,'        Ringworld width = ',RW_Width:20:0,' metres');
          Writeln(Lst,' Ringworld surface area = ',RW_Width * Circumference:20:0,' Sq. Metres, ');
          Writeln(Lst,'                        = ',(RW_Width * Circumference)/10E+12:10:0,' million square Km.');
          Writeln(lst,'1 rotation = ',Orbital_Period:4:2,' days [Earth days]');
       end;

       If planet_Code <>'Q' then if Planet_Code <>'R' then
          Writeln(lst,'Year = ',Orbital_Period:6:2,' days [Earth days]');
     End;

     if Planet_Code <'Q' then if Planet_Code <> '0' then begin;
       Case Char(Ord(Planet_Code[1])) of
        '1'..'5' : Rotation_Period := 0.75 + Random * 0.5;
        '6'..'9' : Rotation_Period := 0.25 + Random;
        'A'..'M' : Rotation_Period := Exact_Radius * Exact_Mass * 30;
             '(' : Rotation_Period := Exact_Radius * Exact_Mass * 30;
             ')' : Rotation_Period := 10.0 + (Random * 10.0);
           end;
        if Planet_Number = 1 then Rotation_Period := (Orbital_Period / (Random(16)+1) * (Random(4)+1));
        Writeln(Lst,'Rotation period = ',Rotation_Period:8:4,' Days [Earth days]');
        If Planet_Number >0 then Writeln(lst,'Planet year = ',Orbital_Period / Rotation_Period: 8:3,' planet days');
        end;

        If Planet_Code >'0' then if Planet_Code <='9' then begin;
        For V:= 0 to 20 do If Moon_Size[V] > -1 then begin;
          If Moon_Size[V] = 0 then Moon_diameter := Random(1000)+ Random
            else Moon_Diameter := (Moon_Size[V] * 1000) + Random(1000);
          Moon_distance := (400000.0 * Bode_Number[v])+Random(100)-50;
          Writeln(lst);
          writeln(Lst,'Moon at ',Moon_Distance:8:0,' Km, Diameter ',Moon_Diameter:5:0,' Km');
          If Moon_Colonies[V,1] > 0 then writeln(Lst,'* Human colony');
          If Moon_Colonies[V,2] > 0 then writeln(Lst,'* Alien colony');
          If Moon_Colonies[V,3] > 0 then writeln(Lst,'* Native colony');
        end;
      end;
      Case Char(Ord(Planet_Code[1])) of
             '0'..'5' : Mineral_Assay;
             'Q'..'S' : Mineral_Assay;
          end;
      end;

      {now binary stars- they really are more trouble than they're worth!}
      If Planet_Code = '*' then begin;
        Total_Binary_Distance := 0;
        For V := 0 to 1 do begin;
           Writeln(lst,'Star ',V,' type ',Binary_Star_Type[v]);
           Writeln(lst,'Hydrogen ',Binary_Star_Atmosphere[V,0],' %');
           Writeln(lst,'Helium ',Binary_Star_Atmosphere[V,1],' %');
           Writeln(lst,'    Gravity = ',Binary_Star_G[V]:5:0);
           Writeln(Lst,'       Mass = ',Binary_Star_Mass[v]:6:3,' [Sol = 1]');
           Writeln(Lst,' Luminosity = ',Binary_Star_Luminosity[v]:7:3);
           Writeln(Lst,'   Diameter = ',Binary_Star_Radius[v] * 1392000.0:10:0,' Km');
           Writeln(lst,'Temperature = ',Binary_Star_Temperature[V]:6:0,' degrees K');
           Write(lst,'Displacement from orbital centre = ');
           Orbital_Distance := (Binary_Star_Distance[v]/4) * Binary_Star_Radius[0];
           Writeln(lst,Orbital_Distance:4:0,' Million Km');
           Total_Binary_Distance := Total_Binary_Distance + Orbital_Distance;
           Writeln(lst);
        End;
        Orbital_Distance := Total_Binary_distance;
        Orbital_Distance := Orbital_Distance / 150.0; {convert to AU}
        Orbital_Period :=
        Sqrt ((Sqr(Orbital_Distance)* Orbital_Distance)/(Binary_Star_G[0]+Binary_Star_G[1]));
        Orbital_Period := Orbital_Period * 365.25; {convert to earth days}
        Writeln(lst,'Pair rotate in ',Orbital_Period:6:2,' days [Earth days]');
        Writeln(lst);
    End;
Writeln(lst,'  ======================================================================'#10#13);
{$I+}
OK := (IOresult = 0);
if not OK then exit;
End;
