Procedure Choose_New_Sun(Position_In_System: Integer);
{part of magrathea, below}
Begin;
  Clearscreen;
  GotoXY(6,6);
  Writeln('Press keys to select star type'#10#13'as follows [most stars are in');
  Writeln('the astronomical main sequence;'#10#13'see documentation for details.]');
  TextColor(1);
  Writeln('Star type B0 B5 A0 A5 F0 F5 G0'#10#13'Key        A  B  C  D  E  F  G');
  Writeln;
  Writeln('Star type G5 K0 K5 M0 M5 M9 DG'#10#13'Key        H  I  J  K  L  M  N');
  Writeln;
  If Position_In_System = 0 then begin;
    Writeln('or "O" for a binary pair'#10#13'   "P" for a black hole'#10#13'   "Q" for a proto-star');
    Writeln;
    TextColor(2);
    Writeln('Editing primary does not change'#10#13'other planets and stars: they'#10#13'should be edited to suit the');
    Writeln('new sun!');
  End
  else begin;
    TextColor(2);
    Writeln('Try to avoid a secondary star'#10#13'that`s larger than the primary.'#10#13'Oxygen worlds aren`t likely in');
    Writeln('any form of multi-star system!');
  End;
  Repeat;
     Beep_Wait;
      Case Dummy of
      'A'..'N': Begin;
                  V := Ord(dummy) - Ord('A');
                  Star_Type := Star_Name_Tags[V];
                  V := 1;
                End;
           'O': If Position_In_System = 0 then Begin; Star_Type := '*' + Chr(Random(40)+10); V := 1; End;
           'P': If Position_In_System = 0 then Begin; Star_Type := '( '; V := 1; End;
           'Q': If Position_In_System = 0 then Begin; Star_Type := ') '; V := 1; End;
      end;
    Until V = 1;
End;

Procedure Replace_Planet;
Begin;
   V:= 1;
   Delete (System_Details [Y_Coordinate, X_Coordinate],(2*Planet_Number) + 4, 1);
   Insert (Dummy, System_Details [Y_Coordinate, X_Coordinate],(2*Planet_Number) + 4);
End;

Procedure Magrathea;
{edit and build solar systems}
Begin;
  If Systems_In_Memory = 0 then
     Begin;
       No_Sector_Error;
       Exit;
     End;
  Choose_System(2);
  If Menu_Status = 0 then exit else
      Begin;
        Colour_Selection;
        WG_System := System_Details [Y_Coordinate, X_Coordinate];
        Protected_System := WG_System;
        Clearscreen;
        If System_Details [Y_Coordinate, X_Coordinate] <= '!' then
             Begin;
                Str (Y_Coordinate, A);
                Str (X_Coordinate, B);
                Str (Random(10), C); {choose a random Z-coordinate}
                System_Location := A + B + C;
                System_Details [Y_Coordinate, X_Coordinate] := System_Location;
                Old_Systems; {call to a badly-named routine}
                New_System_Map; {it's easier to edit something that's there}
             end;
      End;
    Repeat;
      Colour_Selection;
      Edit_Status := 9;
      If System_Details [Y_Coordinate, X_Coordinate] <= '!' then
        System_Window
         else Begin;
           Old_Systems;
           Old_System_Map;
         end;
      For I := 0 to 9 do Numbers((I*17)+5,3,I,3);
      For I := 10 to 17 do begin;
         Numbers((I*17)+5,3,1,3);
         Numbers((I*17)+10,3,I-10,3);
      end;
      GraphWindow(0,33,319,199);
      GotoXY(6,6);
      TextColor(2);
      Security_Tag := Copy(WG_System,40,1);
      Writeln('Press keys to choose options'#10#10#13'[P] Edit PRIMARY star'#10#13'[O] Change ORBITING planet / star');
      Writeln('[Z] Change Z-COORDINATE'#10#13#10#13'[D] DELETE system'#10#13'[G] GENERATE a new system here');
      Write('[S] Change SECURITY to ');
      If Security_Tag = '*' then writeln ('clear') else Writeln ('RESTRICTED');
      Writeln(#10#13'[M] Look at detailed MAPS');
      Writeln(#10#13'[C] CANCEL all changes'#10#13'[X] eXit [accept changes]'#10#10#13'[H] HELP');
      Beep_Wait;
      Case dummy of
      'P': Edit_Status := 0;
      'O': Edit_Status := 1;
      'Z': Edit_Status := 2;
      'D': Edit_Status := 3;
      'G': Edit_Status := 4;
      'M': Edit_Status := 5;
      'C': Edit_Status := 6;
      'X': Edit_Status := 7;
      'S': Edit_Status := 8;
      'H': Edit_status := 9;
      end;

      If Edit_Status = 0 then begin;
      V := 0;
      Choose_New_Sun(0);
      Delete (System_Details [Y_Coordinate, X_Coordinate],4,2);
      Insert (Star_Type, System_Details [Y_Coordinate, X_Coordinate],4);
      End;

      If Edit_Status = 1 then begin;
        Planet_Number := -1;
        ClearScreen;
        GotoXY(6,6);
        Writeln('Press planet number, 1 to 9'#10#13'or A to H for planets 10 to 17');
        Repeat;
          Beep_wait;
          If Dummy >='A' then if Dummy <= 'H' then
            Planet_Number := Ord(Dummy) - Ord('A') + 10;
          If Dummy >='0' then if Dummy <= '9' then
            Val (Dummy,Planet_Number,N);
        Until Planet_Number <> -1;
        ClearScreen;
        GotoXY(6,6);
        Writeln('Planet/Star ',Planet_Number,' selected');
        Writeln('Press for replacement:'#10#13'<Space bar> = nothing'#10#13'   0 = Asteroids');
        Writeln('   1 = Earth-like'#10#13'   2 = Poison atmosphere'#10#13'   3 = Airless, cratered');
        Writeln('   4 = Airless, mountainous'#10#13'   5 = Airless, icy'#10#13' 6-7 = Gas giant [no rings]:');
        Writeln(' 8-9 = Ringed gas giant:'#10#13' [7 & 9 are bigger than 6 & 8]'#10#13'   A = Companion star:');
        Writeln('   Q = Ringworld (poison)'#10#13'   R = Ringworld (oxygen)'#10#13'   S = Dust cloud');
        V := 0;
        Repeat
           Beep_Wait;
           Case Dummy of
           '0'..'9': Replace_Planet;
                ' ': Replace_Planet;
                'A': Begin;
                      Choose_New_Sun(1);
                      Delete (System_Details [Y_Coordinate, X_Coordinate],(2*Planet_Number) + 4, 2);
                      Insert (Star_Type, System_Details [Y_Coordinate, X_Coordinate],(2*Planet_Number) + 4);
                     End;
           'Q'..'S': Replace_Planet;
           End;
        Until V = 1;
      End;

      If Edit_Status = 2 then begin;
          ClearScreen;
          GotoXY(6,6);
          Writeln('Enter new Z-Coordinate, 0 to 9');
          Repeat Beep_Wait until (Dummy >='0') and (Dummy <='9');
          Delete (System_Details [Y_Coordinate, X_Coordinate],3,1);
          Insert (Dummy, System_Details [Y_Coordinate, X_Coordinate],3);
      End;

      If Edit_Status = 3 then begin;
          ClearScreen;
          GotoXY(6,6);
          Writeln('Delete System: Are you sure (Y/N)'#10#13'If you do this, only options'#10#13'[G] GENERATE a new system,');
          Writeln('[L] LOSE all changes, or'#10#13'[X] eXit     will work!!');
          Beep_Wait;
          If Dummy = 'Y' then System_Details[Y_Coordinate,X_Coordinate] := '   ';
      End;

      If Edit_Status = 4 then begin;
         ClearScreen;
         GotoXY(6,6);
         Writeln('Generate a random system?'#10#13'Are you sure (Y/N)??'#10#13'You will lose all edits!!');
         Beep_Wait;
          If Dummy = 'Y' then begin;
             Str (Y_Coordinate, A);
             Str (X_Coordinate, B);
             Str (Random(10), C); {choose a random Z-coordinate}
             System_Location := A + B + C;
             System_Details [Y_Coordinate, X_Coordinate] := System_Location;
             Old_Systems; {call to a badly-named routine}
             New_System_Map;
          end;
      end;

      If Edit_Status = 5 then Planet_Details(1);

      If Edit_Status = 6 then
          System_Details [Y_Coordinate,X_Coordinate] := Protected_System;

      If Edit_Status = 8 then begin;
          Delete (System_Details [Y_Coordinate, X_Coordinate],40,1);
          If Security_Tag <> '*' then Security_Tag := '*' else Security_Tag := ' ';
          Insert (Security_Tag, System_Details [Y_Coordinate, X_Coordinate],40);
        end;

      If edit_Status = 9 then Help('EDIT',' POZDGSMCX');

  Until Edit_Status = 7;
  Make_Mini_Map;
End;
{-------------------------------------------------------------------------}
{                         STATISTICAL ROUTINES                            }
{-------------------------------------------------------------------------}

Procedure Sector_Statistics(Bypass: Integer);
{produce statistics for an entire sector}
Begin;
   Make_Mini_Map;
   Solar_System_Count := 0;
   Binary_Star_Count := 0;
   Oxygen_World_Count := 0;
   Gas_Giant_Count := 0;
   Vacuum_World_Count := 0;
   Poison_World_Count := 0;
   Asteroid_Belt_Count := 0;
   Black_Hole_Count := 0;
   Protostar_Count := 0;
   Ring_World_Count := 0;
   Second_Star_Count := 0;
   Dust_Cloud_Count := 0;
   ClrScr;
   For Y_Coordinate := 0 to 9 Do
      Begin;
        For X_Coordinate := 0 to 9 Do
        Begin;
          WG_System := System_Details [Y_Coordinate, X_Coordinate];
          Old_Systems;
          if WG_System > '!' then Begin;
              Security_Tag := Copy (WG_System,40,1);
              If Security_Tag = '*' then writeln('   Restricted system at ',Y_Coordinate,X_Coordinate,Z_Coordinate);
              Solar_System_Count := Solar_System_Count +1;
              A := Copy (WG_System,4,1);
              Case Char(Ord(A[1])) of
              '*': begin;
                     Binary_Star_Count := Binary_Star_Count +1;
                     Writeln('   Close binary pair at ',Y_Coordinate,X_Coordinate,Z_Coordinate);
                     Delete (Mini_Map [X_Coordinate],2*Y_Coordinate+2,1);
                     Insert ('<',Mini_Map [X_Coordinate],2*Y_Coordinate+2);
                   End;
              '(': begin;
                     Black_Hole_Count := Black_Hole_Count +1;
                     Writeln('   Black hole at ',Y_Coordinate,X_Coordinate,Z_Coordinate);
                     Delete (Mini_Map [X_Coordinate],2*Y_Coordinate+2,1);
                     Insert ('{',Mini_Map [X_Coordinate],2*Y_Coordinate+2);
                    End;
               ')': begin;
                      Protostar_Count := Protostar_Count +1;
                      Writeln('   Proto-Star at ',Y_Coordinate,X_Coordinate,Z_Coordinate);
                      Delete (Mini_Map [X_Coordinate],2*Y_Coordinate+2,1);
                      Insert ('[',Mini_Map [X_Coordinate],2*Y_Coordinate+2);
                    End;
              End;
              For  I := 1 to 17 Do
              Begin;
                A := Copy (WG_System,(I*2)+4,1);
                If A <> ' ' then
                Case Char(Ord(A[1])) of
                 '0': Asteroid_Belt_Count := Asteroid_Belt_Count +1;
                 '1': begin;
                       Oxygen_World_Count := Oxygen_World_Count +1;
                       Delete (Mini_Map [X_Coordinate],2*Y_Coordinate+1,1);
                       Insert ('#',Mini_Map [X_Coordinate],2*Y_Coordinate+1);
                      End;
                 '2': Poison_World_Count := Poison_World_Count +1;
            '3'..'5': Vacuum_World_Count := Vacuum_World_Count +1;
            '6'..'9': Gas_Giant_Count := Gas_Giant_Count +1;
            'A'..'L': Second_Star_Count := Second_Star_Count + 1;
                 'S': Dust_Cloud_Count := Dust_Cloud_Count + 1;
            'Q'..'R': Begin;
                        Ring_World_Count := Ring_World_Count + 1;
                        If A = 'R' then Writeln('   Oxygen Ring world at ',Y_Coordinate,X_Coordinate,Z_Coordinate);
                        If A = 'Q' then Writeln('   Toxic Ring world at ',Y_Coordinate,X_Coordinate,Z_Coordinate);
                      End;
                End;
              End;
            End;
         end;
     End;
   Writeln('This sector contains ',Solar_System_Count,' systems,');
   If Second_Star_Count >0 then Writeln(Second_Star_Count,' systems include secondary stars');
   Writeln(Oxygen_World_Count,' planets have oxygen atmospheres.');
   Writeln(Vacuum_World_Count,' planets have no atmosphere.');
   Writeln(Poison_World_Count,' planets have toxic atmospheres.');
   Writeln(Gas_Giant_Count,' planets are gas giants.');
   Writeln('There are ',Asteroid_Belt_Count,' asteroid belts');
   If Dust_Cloud_Count >0 then Writeln('and ',Dust_Cloud_Count,' dust clouds.');
   Writeln;
   Show_Mini_Map;
   If Bypass = 0 then Beep_Wait else Exit;
   ClrScr;
End;

Procedure System_Statistics(Bypass : Integer);
Begin;
  If Bypass = 0 then Choose_System(3) else Menu_Status := 3;
  If Menu_Status = 3 then Planet_Details(1);
end;

Procedure Full_Sector_Statistics;
Begin;
  Writeln('This procedure takes some time; for best speed'#10#13'use a printer with a large buffer, or');
  Writeln('a spooler program.');
  Writeln('You can stop the run by pressing any key;'#10#13'it will stop at the end of the next system'#10#13);
  Writeln('Press "X" to cancel, or any other key to continue');
  Beep_Wait;
  If Dummy = 'X' then exit;
  Sector_Statistics(1);
  Screen_Dump;
  Colour_Selection;
  GraphWindow(0,0,319,199);
  Draw_Grid;
  For Y_Coordinate := 0 to 9 Do
    For X_Coordinate := 0 to 9 Do
        Begin;
          WG_System := System_Details [Y_Coordinate, X_Coordinate];
          if WG_System > '!' then begin;
              GraphWindow(0,0,319,199);
              System_Location_XYZ;
              System_Statistics(1);
          end;
          Writesafe(1,Chr(12));
          If Keypressed then exit;
        End;
End;

Procedure Show_Sector_Ascii;
Begin;
  Writeln(#10#13'Data is shown in order: coordinates'#10#13'then a symbol for the star or binary:');
  Writeln('   Star type, or "*" & a character = binary, "(" = black hole, ")" = protostar');
  writeln('then symbols for up to 17 orbiting planets, stars, etc.');
  Writeln('   1 = Earth-like'#10#13'   2 = Poison atmosphere'#10#13'   3 = Airless, cratered');
  Writeln('   4 = Airless, mountainous'#10#13'   5 = Airless, icy'#10#13' 6-9 = Gas giants');
  Writeln('   Q = Ringworld (poison atmosphere)'#10#13'   R = Ringworld (oxygen atmosphere)'#10#13'   S = Dust cloud');
  Writeln('   or star type symbol for an orbiting star'#10#13'Final "*" for restricted system'#10#13);
  Beep_Wait;
  Writeln('system ..........Orbit number........... Restricted');
  Writeln('      **1 2 3 4 5 6 7 8 9 A B C D E F G H * Systems');
  For Y_Coordinate := 0 to 9 Do
    For X_Coordinate := 0 to 9 Do begin;
    WG_System := System_Details [Y_Coordinate, X_Coordinate];
      if WG_System > '!' then begin;
         writeln('   ',wg_System);
         delay(500);
      end;
  end;
end;

Procedure Distances;
Var
  Light_Years : Real;
  ZZ : Integer;
Begin;
  Choose_System(5);
  Old_Systems;
  XX := X_Coordinate;
  YY := Y_Coordinate;
  ZZ := Z_Coordinate;
  Top_Of_Menu_Screens;
  WG_Textcolor(Red);
  GotoXY(13,4);
  Write('Distance [light years] from chosen system ');
  WG_Textcolor(Lightblue);
  Writeln(YY,XX,ZZ);
  WG_Textcolor(red);
  Writeln('       0     1     2     3     4     5     6     7     8     9');
  For N := 0 to 9 do begin;
    GotoXY(2,6+(N*2));
    Write(n);
  end;
  For Y_Coordinate := 0 to 9 Do
    For X_Coordinate := 0 to 9 Do
        Begin;
          WG_System := System_Details [Y_Coordinate, X_Coordinate];
          if WG_System > '!' then begin;
              Old_Systems;
              Light_Years := Sqrt(Sqr(Y_Coordinate - YY)+Sqr(X_Coordinate - XX));
              Light_Years := Sqrt(Sqr(Light_Years) + Sqr (Z_Coordinate - ZZ));
              GotoXY(6+(Y_Coordinate*6),6+(X_coordinate*2));
              If (XX = X_Coordinate) and (YY = Y_Coordinate) then
                WG_Textcolor(LightBlue)
                  else WG_Textcolor(LightGreen);
              Write(Light_Years:4:1);
          end;
        end;
  Beep_Wait;
End;



Procedure Statistics;
Begin;
Repeat;
  Top_Of_Menu_Screens;
  If Systems_In_Memory = 0 then
      Begin;
        No_Sector_Error;
        Exit;
      End;
  Writeln ('Sector Statistics section'#10#13'Choose Options;'#10#13'[B] BRIEF analysis of sector data');
  Writeln ('[P] PRINT details of one system'#10#13'[A] Print details of ALL systems');
  Writeln ('[D] DISTANCES between systems');
  Writeln('[V] VIEW sector record (ASCII)'#10#10#13'[X] eXit to main menu'#10#10#13'[H] HELP');
  Statistics_Status := 3;
  Beep_Wait;
    Command := Dummy;
    Case command of
    'B' : Sector_Statistics(0);
    'P' : System_Statistics(0);
    'A' : Full_Sector_Statistics;
    'V' : Show_Sector_ASCII;
    'H' : Help('DATA',' BPAVXD');
    'D' : Distances;
    end;
  Until Command = 'X';
  Statistics_Status := -1;
end;
