Unit WG1;
{part of Worldgen}

INTERFACE

Uses CRT, Printer, Dos, Graph, Turbo3, Graph3;

Const
   OCRA : Array [0..9] of Array [0..7] of Byte =
     (($0,$0,$70,$50,$50,$50,$70,$0),
      ($0,$0,$60,$20,$20,$70,$70,$0),
      ($0,$0,$70,$10,$70,$60,$70,$0),
      ($0,$0,$60,$20,$70,$30,$70,$0),
      ($0,$0,$50,$50,$70,$10,$10,$0),
      ($0,$0,$70,$40,$70,$30,$70,$0),
      ($0,$0,$70,$40,$70,$50,$70,$0),
      ($0,$0,$70,$10,$10,$30,$30,$0),
      ($0,$0,$70,$50,$70,$50,$70,$0),
      ($0,$0,$70,$50,$70,$30,$30,$0));
      {Ocra is computer-style letters 0 to 9}

   Grid : Array [0..7] of Byte =
      ($80,$80,$80,$80,$80,$80,$80,$FF);

   Gasses: Array [0..8] of string[20] =
   ('Hydrogen','Helium','Oxygen','Nitrogen','Halogens','Argon',
    'Carbon Dioxide','Water Vapour','Methane');

   Mineral_Name: Array [0..5] of string [15] =
    ('Oxygen','Silicon','Aluminium','Iron','Other metals','Radioactives');

   Bode_Number: Array[1..18] of real =
   ( 0.2, 0.4, 0.7, 1.0, 1.6, 2.8, 5.2, 10.0, 19.6, 38.8, 77.2, 154.0, 307.4,
    614.8, 1229.2, 2458.0, 4916.0, 9832.0);

   Star_Name_Tags: Array [0..13] of string[2] =
   ('B0','B5','A0','A5','F0','F5','G0','G5','K0','K5','M0','M5','M9','DG');

   Days_In_Month: Array [1..12] of Integer =
   (31,28,31,30,31,30,31,31,31,31,30,31);

   Month_Of_Year: Array [1..12] of string [10] =
   ('January','February','March','April','May','June',
    'July','August','September','October','November','December');

   Day_Of_Week: Array [0..6] of string [10] =
   ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');

Var
  Year,Month,Day,Dayofweek,Hour,Minute,Second,Sec100 : Word;
         Screen_Selection : Integer;
                   C_Or_T : Byte; {colour mode or text mode?}
             X_Coordinate : Integer; {System "X" co-ordinate}
             Y_Coordinate : Integer; {System "Y" co-ordinate}
             Z_Coordinate : Integer; {System "Z" co-ordinate}
 I, IA, IB, IC, ID, N, NN : Integer;     {Local variables}
 X, X1, X2, Y, Y1, Y2, Z, xx, yy : Integer;     {Local variables}
     A, B, C, D           : String [1];  {Local variables}
  E, K, R, S, T, U, V, W  : Integer;     {Local Variables}
        Systems_In_Memory : byte; {check if a system is loaded or generated}
                WG_System : String [40];  {A string taken from System_Details}
         Protected_System : String [40];  {used to save systems in editing etc.}
          System_Location : String [3];
                 Mini_Map : Array [0..9] of String [20];
           System_Details : Array [0..9, 0..9] of String [40];
              Sector_Name : String [15];
              Sector_File : Text;
                   Status : Integer;
              Menu_Status : Integer;
                    Check : Integer;
                     Tilt : Integer;         {Planetary axial tilt}
                    Range : Integer;
         Second_Star_Size : Integer;
        Second_Star_Orbit : Integer;
                       OK : Boolean;
                   Bypass : Integer;
             Introduction : Text;
                Text_File : Text;
                  Help_Me : Text;
                Help_File : String[8];
                File_Name : String[20];
          Line, Help_Line : String[80];
                  Command : Char;
                Star_Type : String[2];
                   Star_H : Integer;
              Star_Chance : Integer;
           Star_Selection : Integer;
          Stars_In_System : Integer;
               Luminosity : Real;
       Primary_Luminosity : Real;
               Exact_Mass : Real;
             Exact_Radius : Real;
             Oxygen_World : Integer;
                    Dummy : Char;         {parameter from keyboard}
             Old_X, Old_Y : Integer;
               World_Type : Integer;
                     Band : Integer;      {gas giant banding}
              Ring_Number : Integer;      {gas giant rings}
            Planet_Number : Integer;
              Planet_Code : String[1];
               Belt_Width : Integer;      {asteroid belt density etc.}
       Solar_System_Count : Integer;      {count parameters are used}
        Binary_Star_Count : Integer;      {in statistical routines}
       Oxygen_World_Count : Integer;
          Gas_Giant_Count : Integer;
       Vacuum_World_Count : Integer;
       Poison_World_Count : Integer;
      Asteroid_Belt_Count : Integer;
       Total_Planet_Count : Integer;
         Black_Hole_Count : Integer;
          Protostar_Count : Integer;
         Ring_World_Count : Integer;
        Second_Star_Count : Integer;
         Dust_Cloud_Count : Integer;
        Statistics_Status : Integer;
               Body_Count : Integer;
            Printer_Setup : Integer;
              Planet_Mass : Real;

                Continent : Integer;      {for world mapping}
              Star_Radius : Integer;
      Star_Display_Radius : Integer;
        Binary_Star_Orbit : Array [0..1] of integer;      {for binary stars}
     Binary_Star_distance : Array [0..1] of integer;
       Binary_Star_Radius : Array [0..1] of real;
   Binary_Star_Atmosphere : Array [0..1, 0..1] of integer;
         Binary_Star_Mass : Array [0..1] of Real;
            Binary_Star_G : Array [0..1] of Real;
            Binary_Star_x : array [0..1] of integer;
  Binary_Star_Temperature : array [0..1] of real;
   Binary_Star_Luminosity : array [0..1] of real;
         Binary_Star_Type : array [0..1] of String[2];
         Binary_Star_Size : array [0..1] of Integer;

                Moon_Size : Array [0..20] of Integer;

            Moon_diameter : Real;
               Moon_width : String[8]; {Moon diameter as string}
            Moon_distance : Real;
      Moon_orbital_Radius : String[8]; {moon distance as string}
           Eccentricity_X : Integer;
           Eccentricity_Y : Integer;
        Mean_Eccentricity : Real;
               Atmosphere : Array [0..8] of Integer; {gasses}
                 Pressure : Real;
                Air_Force : String [5]; {pressure as string}
                  Gravity : Real;
                     Pull : String [7]; {gravity as string}
              Temperature : Real;
                     Heat : String [8]; {temperature as string}
               Distortion : String [6]; {orbital eccentricity as string}
      Primary_Temperature : Real;
              Edit_Status : Integer;
             Dust_Density : Integer;
                Gas_Level : Integer;
           Sun_Shield_Pos : Integer;
              Inverse_Sqr : Real;
         Orbital_Distance : Real;
    Total_Binary_Distance : Real;
           Orbital_radius : String [6]; {Orbital distance as string}
           Orbital_Period : Real;
             Orbital_Time : String [6]; {Orbital_Period as string}
         Orbital_Velocity : Real;
            Circumference : Real;
                 RW_Width : Real;
                 Old_Seed : Array [0..1] of integer;
                 Minerals : Array [0..5] of integer;
             Primary_Mass : Real;
          Rotation_Period : Real;
            Magnification : Integer;
                    Ratio : Integer;

               Native_Life: Integer;
         Native_Technology: Integer;
                  Colonies: Array [1..3] of Byte;
                            {1 is human, 2 is alien, 3 is native (eg cities)}
             Moon_Colonies: Array [0..20, 1..3] of Integer;
                            {1 is human, 2 is alien, 3 is native}
                    Maxcol: Integer;
                RandomSeed: Array [0..1] of Integer;
                   Beep_On: Byte;
                beep_pitch: Integer;
            Demonstration : Byte;
            Security_Code : String [20]; {used by password system}
           Security_Level : Byte;
             Entered_Code : String [20];
             Security_Tag : String [1];  {used for securing individual systems}
               Map_Choice : Byte;
               Map_buffer : Array [0..56,0..206] of byte;
             Cursor_Buffer: Array [0..6,6..30] of byte;
        Cursor_X, Cursor_Y: Integer;
 Old_Cursor_X,Old_Cursor_Y: Integer;
                Small_Map : Array [0..10,0..22] of byte;
                   Astral : Byte; {switch for astrolabe utility}
             Initial_Angle: Integer;
             Current_Angle: Array [1..17] of Word;
              Time_Elapsed: Real;
             Angle_Per_Day: Real;
                Days_Since: Real;
               Total_Angle: Real;
       System_Inclination : Integer;
Planet_Orbit_Displacement : Array [1..17] of Byte;
              Bypass_Setup: Byte;
              Bypass_Title: Byte;
                 Help_Used: Byte;

Procedure WG_TextColor(Selected : Word);
Procedure Tell_The_Time;
Procedure Top_of_Menu_Screens;
Procedure WriteSafe(Ln_or_not: Byte; Anything: String);
Procedure Screen_Dump;
Procedure Beep_Wait;
Procedure Numbers (S,T,U,V:Integer);
Procedure No_Sector_Error;
Procedure ShowText;
Procedure Colour_Selection;
Procedure Setup_Printer;
Procedure Get_Code_Word;
Procedure HELP(Menu_Choice: string; Menu_Options: String);
Procedure Have_A_Nice_Day;
Procedure Go_Away(X,Y: Integer);
Procedure Show_Disk_Error(V: Integer);

Implementation

Procedure WG_TextColor(Selected : Word);
Begin;
  If Screen_Selection = 2 then Textcolor(Selected) else
   if selected > blink then Textcolor(White+Blink)
     else textcolor(white);
End;

Procedure Tell_The_Time; {does what it says}
Begin;
    Getdate(Year,Month,Day,Dayofweek);
    Gettime(Hour,Minute,Second,Sec100);
    Write('Time is ',Hour,'.');
    If Minute < 10 then write ('0');
    Write(minute,' hours on ',Day_of_Week[dayofweek],', ',Day);
    Case day of
      1,21,31 : Write('st');
      2,22 : Write('nd');
      3,23 : Write('rd');
      4..20, 24..30: Write('th');
    end;
    Writeln(' of ',Month_Of_Year[Month],' ',Year);
End;

Procedure Top_of_Menu_Screens; {Title + Tell_The_Time}
Begin;
    If C_or_T = 1 then TextMode(C80) else clrscr;
    C_or_T := 0;
    WG_Textcolor(White);
    Writeln('World Generator 1.3 - Copyright (c) 1988,9 - By Marcus L. Rowland');
    Tell_The_Time;
    If Systems_In_Memory > 0 then write (Systems_In_Memory) else write ('No');
    Write(' systems in memory : Beep is ');
    If Beep_On = 1 then write ('on') else write ('off');
    Write (' : Display ');
    Case Screen_Selection of
    0 : write ('Mono 1');
    1 : write ('Mono 2');
    2 : write ('Colour');
    3 : write ('Not Selected');
    end;
    Writeln(' : Security level ',Security_Level,#10#13);
    WG_Textcolor(LightGreen);
End;

Procedure WriteSafe(Ln_or_not: Byte; Anything: String);
{write to printer without crashing if it is off-line}
Begin;
 {$I-}
 If Ln_or_Not = 0 then Write(Lst,anything) else Writeln(Lst,anything);
 {$I+};
 OK := (IOresult = 0);
End;

Procedure Screen_Dump;
Begin;
  Inline($55/$CD/$05/$5D);
End;

Procedure Beep_Wait; {Does what it says}
Begin;
  If Demonstration = 0 then begin;
    If Beep_On = 1 then begin;
      Sound(beep_pitch);            {This method seems to work}
      Delay(200);            {better than "repeat until keypressed"}
      NoSound;
    End;                     {suggested in the Turbo manual, and}
    Read(Kbd,Dummy);         {produces the variable "Dummy"}
    Dummy := Upcase(Dummy);  {which is always upper case}
    If (Dummy = #27) and Keypressed then begin;
      Read(kbd,Dummy);       {eliminate function key presses}
      Dummy:= ' ';
    end;
  end
  else if Demonstration <> 0 then begin
    Delay (1500);
    If Keypressed then Demonstration := 2;
  end;
  End;

Procedure Numbers (S,T,U,V:Integer);
  {Draw an OCRA number character at coordinates S,T, number is U, Colour
   is V}
   Begin;
     Pattern(OCRA[U]);
     Fillpattern(S,T,S+5,T+5,V);
   End;

Procedure No_Sector_Error;
{makes things a little more idiot proof}
   Begin;
     Writeln;
     WG_Textcolor(LightRed+Blink);
     Writeln('WARNING');
     WG_Textcolor(Yellow);
     Writeln('You have asked to see a sector, or use sector data,');
     Writeln('or save a sector, before loading or generating one'#10#13'Please choose another option');
     Writeln;
     WG_Textcolor(White);
     Writeln('Press any key to continue');
     Beep_wait;
     WG_Textcolor(Yellow);
   End;

Procedure Show_Disk_Error(V: Integer);
{Does what it says}
   Begin;
      Writeln;
      WG_Textcolor(LightRed+Blink);
      Writeln('WARNING');
      WG_Textcolor(Yellow);
      Case V of
        1: writeln('Unable to load sector file');
        2: writeln('Unable to save sector file');
        3: writeln('Unable to load text file ',File_Name,', or file does not exist');
      end;
      Writeln;
      Writeln ('Please check for errors before trying again'#10#13'Thank you for your co-operation');
      Writeln;
      If Random(6) = 0 then writeln ('The computer is YOUR friend');
      Writeln;
      WG_Textcolor(White);
      Writeln('Press any key to continue');
      Beep_wait;
    End;


Procedure ShowText;
{Get a text file from the disk and show it on-screen}
Begin;
  If Demonstration = 2 then exit;
  Assign(Text_File,File_Name);
  {$I-};
  Reset(Text_File);
  {$I+};
  OK := (IOresult = 0);
  if not OK then begin;
      Show_Disk_Error(3);
      Exit;
  End;
  WG_Textcolor(Yellow);
  Repeat
    ReadLn(Text_File,Line);
    Writeln(Line);
  until EOF(Text_File);
  Close(Text_File);
  WG_Textcolor(White);
  Writeln;
  If Demonstration = 0 then writeln ('Press Any Key To Continue')
    else Writeln ('Press Any Key To Interrupt');
  WG_Textcolor(yellow);
  Beep_Wait;
End;

Procedure Colour_Selection;
Begin;
  C_or_T := 1;
  if Screen_Selection = 1 then Begin;
          Graphmode;
          Palette(1);
      end
      else Begin
          GraphColorMode;
          If Screen_Selection = 2 then Palette(2) else Palette(3);
      end;
end;

Procedure Setup_Printer;
Begin;
  Writeln('Set Up Procedure'#10#13'Switch printer on, move to top of form');
  Repeat;
  Writeln('Enter page length eg. 66 [US size] 70 [English A4 paper]');
    Repeat;
      Readln(A,B);
      If A >= '0' then if A <= '9' then Val(A,IA,R) else IA := -1;
      If B >= '0' then if B <= '9' then Val(B,IB,R) else IA := -1;
    Until IA <> -1;
    Printer_Setup := (10 * IA) + IB;
    Writeln('Your page is ',Printer_Setup,' Lines long [y/n]');
    Beep_Wait;
  Until Dummy = 'Y';
Writesafe(1,Chr(27)+'C'+Chr(Printer_Setup)+Chr(27)+'N'+Chr(4));
End;

Procedure Get_Code_Word;
Begin;
   Entered_Code := '';
   Repeat
     Beep_wait;
     If Dummy <> #13 then Entered_Code := Entered_Code + Upcase(Dummy);
     Write ('*');
   Until Dummy = #13;
End;


Procedure HELP(Menu_Choice: string; Menu_Options: String);
Var
  Valid_Choice: Byte;
Begin;
  Top_of_menu_screens;
  file_Name := 'WGHELP\'+Menu_Choice+'.WGH';
  ShowText;
  Valid_Choice := 0;
  Repeat
   For N:= 1 to length(Menu_Options) do
     if (Dummy = Copy(Menu_Options,n,1))
       or (Dummy = '#') then Valid_Choice := 1;
   If Valid_Choice = 0 then Beep_Wait;
  Until Valid_choice = 1;
  If Dummy = ' ' then exit;
  If Dummy <> '#' then file_name :='wghelp\'+Menu_Choice+Dummy+'.WGH';
  if Dummy = '#' then file_Name :='wghelp\COPYRITE.WGH';
  ClrScr;
  showtext;
End;


Procedure Have_A_Nice_Day; {set security clearance}
Begin;
  Top_Of_Menu_Screens;
    If Security_Level > 0 then writeln ('Please enter your security code')
   else Writeln ('Enter a code word or phrase, maximum 20 characters');
   Get_Code_Word;
   If Security_Level > 0 then if Entered_Code <> Security_Code then begin;
     Writeln (#10#13'SORRY - WRONG CODE WORD'#10#13'Press any key to continue'#10#13'Have a nice day!');
     beep_wait;
     exit;
   end;
   Security_Code := Entered_Code;
   Repeat;
     Top_Of_Menu_Screens;
     Writeln ('Please choose new security level:'#10#13);
     Writeln ('[0] No security in use, this menu is accessible without password');
     Writeln ('[1] All other options available but this menu inaccesible without password');
     Writeln ('[2] As 1, and system editing / saving prohibited, no ZOOM on restricted systems');
     Writeln ('[3] As 2, and system generation prohibited');
     Writeln ('[4] As 3, and all ZOOM and DATA options prohibited');
     Writeln ('    At security levels 2 and above the password is needed to end the program');
     Writeln (#10#13'[H] HELP');
     Beep_Wait;
     If Dummy = 'H' then begin;
        Help('SECURE',' 01234');
        Dummy := ' ';
     end;
   Until (Dummy >='0') and (Dummy <='4');
   Val (Dummy,Security_Level,I);
   Writeln(#10#13'Security Level ',Security_Level,' set: have a nice day.'#10#13'The Computer is YOUR friend');
   Writeln('Press "P" to see your password again, any other key to exit');
   Beep_Wait;
   If Dummy = 'P' then begin;
     Writeln (#10#13'The password is >>',Security_Code,'<<');
     Delay (2000);
   end;
end;

Procedure Go_Away(X,Y: Integer);
Begin;
  GotoXY(X,Y);
  Write('N/A');
End;

Begin;
End.
